# Début programme de lecture Télémètre Ultrason (Console+Fonction de rappel)
# Ce programme mesure le télémètre ultrason et affiche la distance dans la console Python.

# S'utiliser avec :
# - Sciencethic 651 049 - Télémètre Ultrason fixe
# - Grove - Ultrasonic Ranger 101020010

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
# Définit la fréquence d'échantillonnage maximum.
plugUno.samplingOn( 20 ) # 20 ms min -> 50 Hz max

################################
# Configuration des E/S
################################
brocheTelemetre = plugUno.get_pin('d:2:u')
# -> d : signifie mode tout-ou-rien/digital
# -> u : numéro de la broche, seul 2/3 sont compatible
# -> u : mode télémètre ultrason

# Conversion expliqué interval de temps vers distance
def convertirIntervalTempsEnDistance(tempsAlleEtRetour):    
    # distance = vitesseDuSon * temps
    vitesseDuSon = 331 # m/s
    distanceEnMetre = vitesseDuSon * ( tempsAlleEtRetour / 2 ) * 1E-6
    return distanceEnMetre

# Définit la fonction qui sera appelé a chaque mesure d'interval de temps télémètre
compteurMesure = 0
def fonctionDeRappelLectureTelemetre(tempsAllerEtRetour):
    # variable tempsAlleRetour :
    # interval de temps en microseconde entre le signal émis et le signal recu
    global compteurMesure
    print(
        "("+str(compteurMesure)+") "
        "Valeur brute : ",
        tempsAllerEtRetour,"us "
        "(soit ",
        "{:.2f}".format( convertirIntervalTempsEnDistance( tempsAllerEtRetour ) * 1E2 ),    
        " cm selon 331 m/s la vitesse du son)"
    )
    compteurMesure += 1

input(
    "\nLe programme est pret a effectuer des mesurer avec le télémètre ultrason.\n"
    "Appuyer sur \"ENTRER\" pour demarrer.\n"
    "L'acquisition prendra fin au bout de 5 secondes"
)

# Associe la fonction de rappel définie ci-dessus a l'énement de mise a jour mesure d'interval de temps télémètre
brocheTelemetre.register_callback(fonctionDeRappelLectureTelemetre)

sleep(5)

# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()
# Termine l'éxecution du programme Python.
#exit()
    
# Fin programme de lecture Télémètre Ultrason (Console+Fonction de rappel)
